 ;(function() {
   function XshippingproEstimator() {
       var tpl = {
          header : '<div class="shipping-header">'+_xshippingpro['lang']['header']+'</div>',
          country : '<div class="shipping-field"><select id="xshippingpro-country" name="_xshippingpro[country_id]" class="form-control"></select></div>',
          zone : '<div class="shipping-field"><select id="xshippingpro-zone" name="_xshippingpro[zone_id]" class="form-control"><option value="">'+_xshippingpro['lang']['zone']+'</option></select></div>',
          postal : '<div class="shipping-field"><input type="text" name="_xshippingpro[postcode]" id="input-postcode" placeholder="'+_xshippingpro['lang']['postal']+'" class="form-control" /></div>',
          btn : '<button type="button" id="estimate-xshipping" class="btn btn-default btn-block"><i style="display:none" class="fa fa-spinner fa-spin loader-icon"></i>&nbsp;'+_xshippingpro['lang']['btn']+'</button>',
          quote: '<div class="xshippingpro-quote"><b>{title}</b> {cost}</div>'
       };

       this.pouplateCountry = function() {
          if (_xshippingpro['country']) {
              var _options ='<option value="">'+_xshippingpro['lang']['country']+'</option>';
              $.each(_xshippingpro['country'], function (i, item) {
                  _options += '<option value="'+item.country_id+'">'+item.name+'</option>';
              });
              $('#xshippingpro-country').html(_options);
          }
       }

       this.initEvent = function() {
           $('#xshippingpro-country').on('change', _click_on_country);
           $('#estimate-xshipping').on('click', _click_on_button);
       }

       this.getQuoteBox = function() {
          var quote_box = '<div id="xshippingpro-box" class="xshippingpro-box">';
          quote_box += tpl.header;
          quote_box += '<div class="shipping-fields">';
          quote_box += '<input type="hidden" value="'+_xshippingpro['meta']['product_id']+'" name="_xshippingpro[product_id]" />';
          if (_xshippingpro['meta']['country']) {
             quote_box += tpl.country;
          }
          if (_xshippingpro['meta']['zone']) {
             quote_box += tpl.zone;
          }
          if (_xshippingpro['meta']['postal']) {
             quote_box += tpl.postal;
          }
          quote_box += '</div>';
          quote_box += tpl.btn;
          quote_box += '</div>';
          return quote_box;
       }

       function _click_on_country() {
          $('#xshippingpro-box input[type="text"], #xshippingpro-box select').removeClass('xshippingpro-error');
           $.ajax({
              url: _xshippingpro['url']['country'] + '&country_id=' + this.value,
              dataType: 'json',
              success: function(json) {
                var _options = '<option value="">'+_xshippingpro['lang']['zone']+'</option>';
                if (json['zone']) {
                   $.each(json['zone'], function (i, item) {
                     _options += '<option value="'+item.zone_id+'">'+item.name+'</option>';
                   });
                }
                $('#xshippingpro-zone').html(_options);
              }
          });
       }

       function _click_on_button() {
          $('.xshippingpro-quotes').remove();
          $('#xshippingpro-box input[type="text"], #xshippingpro-box select').removeClass('xshippingpro-error');
          var is_valid = true;
          $('#xshippingpro-box input[type="text"], #xshippingpro-box select').each(function() {
              if (!$(this).val()) {
                 is_valid = false;
                 $(this).addClass('xshippingpro-error');
              }
          });
          if (!is_valid) {
             return;
          }
          $.ajax({
              url: _xshippingpro['url']['estimate'],
              dataType: 'json',
              data: $('#xshippingpro-box :input').serialize(),
              type:'POST',
              beforeSend: function() {
                $('#estimate-xshipping').attr('disabled', true).find('i').css('display','inline');
              },
              complete: function() {
                $('#estimate-xshipping').attr('disabled', false).find('i').css('display','none');
              },
              success: function(json) {
                 var _shippping_data = '<div class="xshippingpro-quotes">';
                 if (json && json.quote) {
                    $.each(json.quote, function (i, item) {
                       _shippping_data += tpl.quote.replace('{title}', item.title).replace('{cost}', item.text);
                    });
                 } else {
                    _shippping_data += '<div class="xshippingpro-no-quote">'+_xshippingpro['lang']['no_data']+'</div>';
                 }
                 _shippping_data += '</div>';
                 $('#xshippingpro-box').after(_shippping_data);
              }
          });
       }

       var quote_box = this.getQuoteBox();
       $(_xshippingpro['meta']['selector']).after(quote_box);
       this.pouplateCountry();
       this.initEvent();
    }
    new XshippingproEstimator();
  })();